<?php
session_start();

include('db.php'); 

$user_id = $_SESSION['user_id'] ?? null;

if (!$user_id) {
    echo json_encode([
        'status' => 'error',
        'message' => 'User not logged in.'
    ]);
    exit;
}

$query = "
    SELECT 
        c.Cart_id,
        c.Quantity,
        c.Created_Date,
        p.Product_id,
        p.Product_name,
        p.Product_image,
        p.Price,
        p.MRP,
        p.Selling_price,
        p.qty,
        p.tax,
        p.Tax_percentage,
        cat.category_ID,
        cat.name AS category_name,
        v.Variant_ID,
        v.color AS variant_color,
        v.size AS variant_size
    FROM 
        cart c
    INNER JOIN 
        product p ON c.Product_id = p.Product_id AND p.mode = 1 AND p.Delete_status = 0
    LEFT JOIN 
        categories cat ON c.Category_id = cat.category_ID
    LEFT JOIN 
        product_variants v ON c.Variant_id = v.Variant_ID AND c.Product_id = v.Product_ID
    WHERE 
        c.User_id = '$user_id' AND c.Delete_status = 0
";

$result = mysqli_query($conn, $query);

if ($result) {
    $cart_data = [];
    while ($row = mysqli_fetch_assoc($result)) {
        $cart_data[] = $row;
    }

    if (!empty($cart_data)) {
        $order_no = generateOrderNumber(); 
        $invoice_no = generateInvoiceNumber(); 
        $created_date = date('Y-m-d H:i:s');
        $due_date = date('Y-m-d', strtotime('+7 days'));
        $total_price = 0;
        $total_discount = 0;
        $total_tax =0 ;
        $total_savings = 0;
        $total_items = count($cart_data);

        $order_query = "
            INSERT INTO orders (
                Invoice_id, order_no, user_id, Created_date, Due_date, Total_price, 
                Total_discount, Tax, Tax_percentage, Discount, Discount_percentage, 
                No_of_items, Created_id, Editor_id, Delete_status
            ) VALUES (
                0, '$order_no', '$user_id', '$created_date', '$due_date', 
                '$total_price', '$total_discount', '$total_tax', '0', '0', '0', 
                '$total_items', '$user_id', '$user_id', 0
            )";

        if (mysqli_query($conn, $order_query)) {
            $order_id = mysqli_insert_id($conn); 

            $invoice_query = "
                INSERT INTO invoice (
                    order_id, Estimate_id, invoice_no, user_id, Created_date, Due_date, 
                    Total_price, Total_discount, Tax, Tax_percentage, Discount, Discount_percentage, 
                    No_of_items, Created_id, Editor_id, Delete_status
                ) VALUES (
                    '$order_id', 0, '$invoice_no', '$user_id', '$created_date', '$due_date', 
                    '$total_price', '$total_discount', '$total_tax', '0', '0', '0', 
                    '$total_items', '$user_id', '$user_id', 0
                )";

            if (mysqli_query($conn, $invoice_query)) {
                $invoice_id = mysqli_insert_id($conn); 

                foreach ($cart_data as $product) {
                    $product_id = $product['Product_id'];
                    $product_name = $product['Product_name'];
                    $quantity = $product['Quantity'];
                    $selling_price = $product['Selling_price'];
                    $mrp = $product['MRP'];
                    $discount_percentage = $product['Discount_percentage'] ?? 0; 
                    $tax_percentage = $product['Tax_percentage'] ?? 0;  
                    $discount = ($selling_price * $quantity) * ($discount_percentage / 100);
                    $tax = ($selling_price * $quantity) * ($tax_percentage / 100);
                    $product_total = $selling_price * $quantity;

                    $order_data_query = "
                        INSERT INTO order_data (
                            Order_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
                            Tax_percentage, Tax, Product_total, Delete_status
                        ) VALUES (
                            '$order_id', '$product_id', '$quantity', '$selling_price', '$mrp', '$discount', 
                            '$discount_percentage', '$tax_percentage', '$tax', '$product_total', 0
                        )";
                    mysqli_query($conn, $order_data_query);

                    $invoice_data_query = "
                        INSERT INTO invoice_data (
                            invoice_id, Product_id, qty, Selling_price, MRP, discount, Discount_percentage, 
                            Tax_percentage, Tax, Product_total, Delete_status
                        ) VALUES (
                            '$invoice_id', '$product_id', '$quantity', '$selling_price', '$mrp', '$discount', 
                            '$discount_percentage', '$tax_percentage', '$tax', '$product_total', 0
                        )";
                    mysqli_query($conn, $invoice_data_query);

                     // Subtract quantity from the `product` table
        $update_product_query = "
        UPDATE product 
        SET qty = qty - '$quantity' 
        WHERE Product_id = '$product_id'
    ";
    mysqli_query($conn, $update_product_query);

    $update_inventory_query = "UPDATE inventory  
    SET Qty = Qty - '$qty',
    date_modified = NOW()
    WHERE Product_id = '$product_id'";

mysqli_query($conn, $update_inventory_query);

                    
                    $total_price += $product_total;
                    $total_discount += $discount * $quantity;
                    $total_tax += $tax;
                    $total_savings += $discount * $quantity;
                }

                $update_order_query = "
                    UPDATE orders SET 
                    Total_price = '$total_price', 
                    Total_discount = '$total_discount', 
                    Tax = '$total_tax', 
                    Total_saving = '$total_savings', 
                    Invoice_id = '$invoice_id'
                    WHERE Order_id = '$order_id'
                ";
                mysqli_query($conn, $update_order_query);

                $update_invoice_query = "
                    UPDATE invoice SET 
                    Total_price = '$total_price', 
                    Total_discount = '$total_discount', 
                    Tax = '$total_tax', 
                    Total_saving = '$total_savings' 
                    WHERE invoice_id = '$invoice_id'
                ";
                mysqli_query($conn, $update_invoice_query);

                $formatted_order_no = 'ORD-' . str_pad($order_id, 4, '0', STR_PAD_LEFT);
                $formatted_invoice_no = 'INV-' . str_pad($invoice_id, 4, '0', STR_PAD_LEFT);

                $update_order_no_query = "
                    UPDATE orders SET order_no = '$formatted_order_no' WHERE order_id = '$order_id'
                ";
                mysqli_query($conn, $update_order_no_query);

                $update_invoice_no_query = "
                    UPDATE invoice SET invoice_no = '$formatted_invoice_no' WHERE invoice_id = '$invoice_id'
                ";
                mysqli_query($conn, $update_invoice_no_query);
                

                echo json_encode([
                    'status' => 'success',
                    'message' => 'Order and invoice created successfully.',
                    'order_id' => $order_id,
                    'invoice_id' => $invoice_id,
                    'order_no' => $formatted_order_no,
                    'invoice_no' => $formatted_invoice_no
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => 'Failed to create invoice.',
                    'error' => mysqli_error($conn)
                ]);
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to create order.',
                'error' => mysqli_error($conn)
            ]);
        }
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'No products in the cart.'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to fetch cart data.',
        'error' => mysqli_error($conn)
    ]);
}

mysqli_close($conn);

function generateOrderNumber() {
    return 'ORD-' . str_pad(rand(1, 9999), 4, '0', STR_PAD_LEFT);
}

function generateInvoiceNumber() {
    return 'INV-' . str_pad(rand(1, 9999), 4, '0', STR_PAD_LEFT);
}
?>
